#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "a.h"
#include "Parser.h"
#include "ParserIO.h"

class IOC : public ParserIO
{
public:
	int read_text(char *s,int *l) {
		*l = read(0, s, *l);
		if (*l > -1)
			s[*l] = 0;
		return *l;
	}
	int write_text(char *s,int l) {
		s[l] = 0;
		printf("%s",s);
		fflush(stdout);
		return 0;
	}
};


int main(int argc,char *argv[])
{
	IOC ioc;
	Parser *p;
	int loop;
	short source = 0;

	for (loop = 1; loop < argc; loop++)
		if (!strcmp(argv[loop],"-source"))
			source++;

	if (argc > 1)
	{
		p = new Parser(argv[1],source);
		p -> SetParserIO(&ioc);
		if (!source)
			p -> run();
		delete p;
	} else
	{
		printf("Usage: %s <A file> [-source]\n",*argv);
	}
	return 0;
}

